<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                xmlns:inn="http://kartverket.no/grunnbok/wsapi/v2/domain/innsending"
                version="1.0"
                exclude-result-prefixes="xsi inn">

    <xsl:output method="xml" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
                doctype-public="-//W3C//DTD XHTML 1.0 Transitional// EN" indent="yes" encoding="ISO-8859-1"/>
    <xsl:template match="/">
        <html>
            <head>
                <title id="dokumentTitle">Dokument til signering</title>
                <style type="text/css" id="cssStyle">
                    body {
                    font-family: "Times New Roman";
                    font-size: small;
                    }
                    table {
                    table-layout: fixed;
                    border: thin solid;
                    width: 100%;
                    margin-bottom: 4em;
                    }
                    .table-header {
                    font-weight: bold;
                    font-size: medium;
                    }
                    .table-header-small{
                    font-size: medium;
                    }
                    .table-header td {
                    padding-top: 1em;
                    }
                    .table-subheader {
                    font-weight: bold;
                    font-size: small;
                    background-color: lightgrey;
                    }
                    .table-subheader-bg-white {
                    font-weight: bold;
                    font-size: small;
                    }
                    .align-right {
                    text-align: right;
                    }
                    td span{
                    margin-right: 0.25em;
                    }
                    p {
                    margin: 0.25em;
                    }
                    #omfang, #forsikring, #forfall{
                    padding-bottom: 8px;
                    }
                </style>
            </head>

            <body>
                <div id="ingress">
                    <span id="dokumentTilSigneringHeader">
                        <xsl:element name="h1">Dokument til signering</xsl:element>
                    </span>
                </div>
                <xsl:apply-templates select="//inn:dokument/inn:rettsstiftelser"/>
                <div id="postgress"/>

                <xsl:call-template name="fotnote">
                    <xsl:with-param name="rettstiftelse" select="//inn:dokument/inn:rettsstiftelser/*"/>
                </xsl:call-template>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="inn:dokument/inn:rettsstiftelser">

        <xsl:apply-templates
                select="inn:eierskifteMatrikkelenhet | inn:overdragelseAvFesterett | inn:eierskifteBorettslagsandel | inn:pant | inn:sletting | inn:annenHeftelse | inn:prioritetsbestemmelseForDokumentnummer | inn:prioritetsbestemmelseForIkkeTinglystDokument | inn:nedkvittering | inn:transport | inn:tinglysingPaaNy | inn:anmerkningPaaRegisterenhetsrettsandel"/>
    </xsl:template>

    <xsl:template match="inn:eierskifteMatrikkelenhet | inn:eierskifteBorettslagsandel |inn:overdragelseAvFesterett">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <tr class="table-header">
                    <td colspan="8">Overdragelsen gjelder</td>
                </tr>
                <xsl:apply-templates select="inn:omsetning/inn:omsatteRegisterenhetsretter"/>

                <xsl:if test="inn:rettsstiftelsestype/inn:kodeverdi != 'TF_OUB'">
                    <tr class="table-header">
                        <td colspan="8">Kj&#248;pesum</td>
                    </tr>
                    <xsl:apply-templates select="inn:omsetning/inn:vederlag"/>
                </xsl:if>

                <xsl:if test="inn:omsetning/inn:dokumentavgiftsplikt">
                    <tr class="table-header">
                        <td colspan="8">Salgsverdi/avgiftsgrunnlag</td>
                    </tr>
                    <xsl:apply-templates select="inn:omsetning/inn:dokumentavgiftsplikt"/>
                </xsl:if>

                <xsl:if test="inn:tekster/*">
                    <tr class="table-header">
                        <td colspan="8">Tekst</td>
                    </tr>
                    <xsl:apply-templates select="inn:tekster"/>
                </xsl:if>

                <xsl:if test="inn:erklaeringerOmSivilstand/*">
                    <xsl:apply-templates select="inn:erklaeringerOmSivilstand"/>
                </xsl:if>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:pant">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>
                <xsl:call-template name="rettstiftelseStandardTekst">
                    <xsl:with-param name="rettstiftelseTypeKode" select="inn:rettsstiftelsestype/inn:kodeverdi"/>
                </xsl:call-template>
                <xsl:if test="inn:pantsettere/*">
                    <xsl:apply-templates select="inn:pantsettere"/>
                </xsl:if>

                <tr class="table-header">
                    <td colspan="8">Pantekravets st&#248;rrelse</td>
                </tr>
                <xsl:apply-templates select="inn:beloep"/>

                <tr class="table-header">
                    <td colspan="8">Panthaver</td>
                </tr>
                <xsl:apply-templates select="inn:rettighetshavere"/>

                <tr class="table-header">
                    <td colspan="8">Panteobjekt</td>
                </tr>
                <xsl:apply-templates select="inn:hefterI"/>

                <xsl:if test="inn:tekster/*">
                    <tr class="table-header">
                        <td colspan="8">Tekst</td>
                    </tr>
                    <xsl:apply-templates select="inn:tekster"/>
                </xsl:if>

                <xsl:if test="
                inn:omfang/inn:vilkaarGjelder = 'true' or
                inn:forsikring/inn:vilkaarGjelder = 'true' or
                inn:forfall/inn:vilkaarGjelder = 'true'">
                    <tr class="table-header">
                        <td colspan="8">Bestemmelser som ikke er gjenstand for tinglysing</td>
                    </tr>
                </xsl:if>

                <xsl:if test="inn:omfang/*">
                    <xsl:apply-templates select="inn:omfang"/>
                </xsl:if>

                <xsl:if test="inn:forsikring/*">
                    <xsl:apply-templates select="inn:forsikring"/>
                </xsl:if>

                <xsl:if test="inn:forfall/*">
                    <xsl:apply-templates select="inn:forfall"/>
                </xsl:if>

                <xsl:if test="inn:erklaeringerOmSivilstand/*">
                    <xsl:apply-templates select="inn:erklaeringerOmSivilstand"/>
                </xsl:if>

            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:annenHeftelse">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <xsl:call-template name="rettstiftelseStandardTekst">
                    <xsl:with-param name="rettstiftelseTypeKode" select="inn:rettsstiftelsestype/inn:kodeverdi"/>
                </xsl:call-template>

                <xsl:if test="inn:rettighetshavere/* or inn:realkobletTil/*">
                    <tr class="table-header">
                        <td colspan="8">Rettighetshaver</td>
                    </tr>
                    <xsl:apply-templates select="inn:rettighetshavere"/>
                    <xsl:apply-templates select="inn:realkobletTil"/>
                </xsl:if>

                <tr class="table-header">
                    <td colspan="8">Hefter i</td>
                </tr>
                <xsl:apply-templates select="inn:hefterI"/>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:sletting">
        <table>
            <tbody>
                <xsl:call-template name="rettsendringMedEndredeRettsstiftelserITabell">
                    <xsl:with-param name="endredeHeaderText">Rettsstiftelse som skal slettes</xsl:with-param>
                </xsl:call-template>
                <xsl:call-template name="teksterITabell"/>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:transport">
        <table>
            <tbody>
                <xsl:call-template name="rettsendringMedEndredeRettsstiftelserITabell">
                    <xsl:with-param name="endredeHeaderText">
                        <xsl:choose>
                            <xsl:when test="./inn:rettsstiftelsestype/inn:kodeverdi='TR_FUS'">Rettsstiftelse(r) som endres</xsl:when>
                            <xsl:otherwise>Rettsstiftelse(r) som transporteres</xsl:otherwise>
                        </xsl:choose>
                    </xsl:with-param>
                </xsl:call-template>

                <xsl:call-template name="transportTableHeader">
                    <xsl:with-param name="text">fra</xsl:with-param>
                </xsl:call-template>
                <xsl:apply-templates select="inn:fraRettighetshaver"/>
                <xsl:apply-templates select="inn:fraRealkobletTil"/>

                <xsl:call-template name="transportTableHeader">
                    <xsl:with-param name="text">til</xsl:with-param>
                </xsl:call-template>
                <xsl:apply-templates select="inn:tilRettighetshaver"/>
                <xsl:apply-templates select="inn:tilRealkobletTil"/>
                <xsl:call-template name="teksterITabell"/>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template name="transportTableHeader">
        <xsl:param name="text"/>
        <xsl:param name="erFusjon" select="./inn:rettsstiftelsestype/inn:kodeverdi='TR_FUS'"/>
        <tr class="table-header">
            <td colspan="8">
                <xsl:choose>
                    <xsl:when test="$erFusjon"><xsl:value-of select="concat('Endres ', $text)"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="concat('Transporteres ', $text)"/></xsl:otherwise>
                </xsl:choose>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="rettsendringMedEndredeRettsstiftelserITabell">
        <xsl:param name="endredeHeaderText"/>
        <xsl:call-template name="rettsstiftelseNavnOgNummer">
            <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
            <xsl:with-param name="index" select="position()"/>
        </xsl:call-template>

        <xsl:if test="./inn:rettsstiftelsestype/inn:kodeverdi='TR_MAS'">
            <xsl:apply-templates select="./inn:skalHaGebyr"/>
        </xsl:if>
        <tr class="table-header">
            <td colspan="8">
                <xsl:value-of select="$endredeHeaderText"/>
            </td>
        </tr>
        <tr class="table-subheader">
            <td>Dokument&#229;r</td>
            <td>Dokumentnr.</td>
            <td>Rettsst.nr.</td>
            <td>Embetenr.</td>
            <td colspan="4">Rettsstiftelsestype</td>
        </tr>
        <xsl:apply-templates select="inn:endrer"/>
    </xsl:template>

    <xsl:template match="inn:skalHaGebyr">
        <tr class="table-header">
            <td/>
        </tr>
        <tr>
            <td colspan="8">
                <span class="table-subheader">Gebyr</span>
                <span>
                    <xsl:call-template name="jaNei">
                        <xsl:with-param name="booleanValue" select="."/>
                    </xsl:call-template>
                </span>
                <xsl:if test="./following-sibling::inn:aarsakGebyrfritak">
                    <span class="table-subheader">&#197;rsak</span>
                    <span>
                        <xsl:value-of select="./following-sibling::inn:aarsakGebyrfritak/inn:navn"/>
                    </span>
                </xsl:if>
            </td>
        </tr>
    </xsl:template>

    <xsl:template name="teksterITabell">
        <xsl:if test="inn:tekster/*">
            <tr class="table-header">
                <td colspan="8">Tekst</td>
            </tr>
            <xsl:apply-templates select="inn:tekster"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="inn:fraRettighetshaver | inn:tilRettighetshaver">
        <xsl:if test="./*">
            <xsl:call-template name="personerITabell">
                <xsl:with-param name="class">
                    <xsl:value-of select="local-name()"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="inn:fraRealkobletTil | inn:tilRealkobletTil">
        <xsl:if test="./*">
            <xsl:call-template name="realkobletTilITabell">
                <xsl:with-param name="class">
                    <xsl:value-of select="local-name()"/>
                </xsl:with-param>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template match="inn:nedkvittering">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <tr class="table-header">
                    <td colspan="8">Rettsstiftelse som nedkvitteres</td>
                </tr>
                <tr class="table-subheader">
                    <td>Dokument&#229;r</td>
                    <td>Dokumentnr.</td>
                    <td>Rettsst.nr.</td>
                    <td>Embetenr.</td>
                    <td colspan="4">Rettsstiftelsestype</td>
                </tr>
                <xsl:apply-templates select="inn:endrer"/>

                <tr class="table-header">
                    <td colspan="8">Bel&#248;pet er nedkvittert til</td>
                </tr>
                <xsl:apply-templates select="inn:beloepNedkvittertTil"/>

                <xsl:if test="inn:tekster/*">
                    <tr class="table-header">
                        <td colspan="8">Tekst</td>
                    </tr>
                    <xsl:apply-templates select="inn:tekster"/>
                </xsl:if>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:tinglysingPaaNy">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <tr class="table-header">
                    <td colspan="8">Rettsstiftelse som tinglyses p&#229; ny</td>
                </tr>
                <tr class="table-subheader">
                    <td>Dokument&#229;r</td>
                    <td>Dokumentnr.</td>
                    <td>Rettsst.nr.</td>
                    <td>Embetenr.</td>
                    <td colspan="4">Rettsstiftelsestype</td>
                </tr>
                <xsl:apply-templates select="inn:endrer"/>

                <xsl:if test="inn:tekster/*">
                    <tr class="table-header">
                        <td colspan="8">Tekst</td>
                    </tr>
                    <xsl:apply-templates select="inn:tekster"/>
                </xsl:if>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:anmerkningPaaRegisterenhetsrettsandel">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <tr class="table-header">
                    <td colspan="8">Gjelder</td>
                </tr>
                <xsl:apply-templates select="inn:gjelder"/>
            </tbody>
        </table>
    </xsl:template>

    <xsl:template match="inn:prioritetsbestemmelseForIkkeTinglystDokument">
        <table>
            <tbody>
                <xsl:call-template name="rettsstiftelseNavnOgNummer">
                    <xsl:with-param name="rettsstiftelseNavn" select="inn:rettsstiftelsestype/inn:navn"/>
                    <xsl:with-param name="index" select="position()"/>
                </xsl:call-template>

                <tr class="table-header">
                    <td colspan="8">Rettsstiftelse som viker</td>
                </tr>
                <tr class="table-subheader">
                    <td>Dokument&#229;r</td>
                    <td>Dokumentnr.</td>
                    <td>Rettsst.nr.</td>
                    <td>Embetenr.</td>
                    <td colspan="4">Rettsstiftelsestype</td>
                </tr>
                <xsl:apply-templates select="inn:endrer"/>

                <xsl:if test="inn:sidestiltMed/*">
                    <tr class="table-header sidestiltMed">
                        <td colspan="8">Sidestilt med</td>
                    </tr>
                    <xsl:for-each select="inn:sidestiltMed">
                        <xsl:call-template name="beloepITabell"/>
                    </xsl:for-each>
                </xsl:if>

                <xsl:if test="inn:medBeloep/*">
                    <xsl:apply-templates select="inn:medBeloep"/>
                </xsl:if>

                <xsl:if test="inn:veketFor/*">
                    <tr class="table-header veketFor">
                        <td colspan="8">Viker for</td>
                    </tr>
                    <xsl:for-each select="inn:veketFor">
                        <xsl:call-template name="beloepITabell"/>
                    </xsl:for-each>
                </xsl:if>

                <xsl:if test="inn:rettighetshavere/*">
                    <tr class="table-header">
                        <td colspan="8">Panthaver</td>
                    </tr>
                    <xsl:apply-templates select="inn:rettighetshavere"/>
                </xsl:if>

                <xsl:if test="inn:forBeloep/*">
                    <xsl:apply-templates select="inn:forBeloep"/>
                </xsl:if>

                <xsl:if test="inn:tekster/*">
                    <tr class="table-header">
                        <td colspan="8">Tekst</td>
                    </tr>
                    <xsl:apply-templates select="inn:tekster"/>
                </xsl:if>
            </tbody>
        </table>
    </xsl:template>


    <xsl:template match="inn:prioritetsbestemmelseForDokumentnummer">
        <table>
            <tbody>
                <xsl:call-template name="rettsendringMedEndredeRettsstiftelserITabell">
                    <xsl:with-param name="endredeHeaderText">Rettsstiftelse(r) som viker prioritet</xsl:with-param>
                </xsl:call-template>
                <xsl:if test="inn:medBeloep/*">
                    <xsl:apply-templates select="inn:medBeloep"/>
                </xsl:if>

                <xsl:if test="inn:veketFor/*">
                    <xsl:apply-templates select="inn:veketFor"/>
                </xsl:if>

                <xsl:if test="inn:sidestiltMed/*">
                    <xsl:apply-templates select="inn:sidestiltMed"/>
                </xsl:if>

                <xsl:if test="inn:forBeloep/*">
                    <xsl:apply-templates select="inn:forBeloep"/>
                </xsl:if>

                <xsl:call-template name="teksterITabell"/>
            </tbody>
        </table>
    </xsl:template>


    <xsl:template match="inn:medBeloep">
        <tr class="table-header">
            <td class="medBeloep" colspan="8">Viker med bel&#248;p</td>
        </tr>
        <xsl:call-template name="beloepITabell"/>
    </xsl:template>

    <xsl:template match="inn:forBeloep">
        <tr class="table-header">
            <td class="forBeloep" colspan="8">Viker for bel&#248;p</td>
        </tr>
        <xsl:call-template name="beloepITabell"/>
    </xsl:template>

    <xsl:template match="inn:vederlag">
        <xsl:choose>
            <xsl:when test="inn:beloepstekst">
                <tr class="table-subheader">
                    <td colspan="1">Bel&#248;p</td>
                    <td colspan="1">Valuta</td>
                    <td colspan="2">Bel&#229;pstekst</td>
                    <td colspan="2">Omsetningstype</td>
                    <td colspan="2">Utlyst til salg p&#229; det frie marked</td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr class="table-subheader">
                    <td colspan="1">Bel&#248;p</td>
                    <td colspan="1">Valuta</td>
                    <td colspan="2"></td>
                    <td colspan="2">Omsetningstype</td>
                    <td colspan="2">Utlyst til salg p&#229; det frie marked</td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        <tr class="vederlag">
            <td colspan="1" class="beloepsverdi">
                <xsl:call-template name="formaterBeloepsverdi">
                    <xsl:with-param name="beloepsverdi" select="inn:beloepsverdi"/>
                </xsl:call-template>
            </td>
            <td colspan="1" class="valutakode">
                <xsl:value-of select="inn:valutakode/inn:kodeverdi"/>
            </td>
            <td colspan="2" class="beloepstekst">
                <xsl:value-of select="inn:beloepstekst"/>
            </td>
            <td colspan="2" class="omsetningstype">
                <xsl:value-of select="../inn:omsetningstype/inn:navn"/>
            </td>
            <td colspan="2" class="utlystfriemarked">
                <xsl:call-template name="jaNei">
                    <xsl:with-param name="booleanValue" select="../inn:utlystTilSalgPaaDetFrieMarked"/>
                </xsl:call-template>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="inn:dokumentavgiftsplikt">
        <xsl:choose>
            <xsl:when test="inn:dokumentavgiftsgrunnlag/inn:beloepstekst">
                <tr class="table-subheader">
                    <td colspan="1">Bel&#248;p</td>
                    <td colspan="1">Valuta</td>
                    <td colspan="2">Tilleggsansvar</td>
                    <td colspan="4">Dokumentavgifts&#229;rsak</td>
                </tr>
            </xsl:when>
            <xsl:otherwise>
                <tr class="table-subheader">
                    <td colspan="1">Bel&#248;p</td>
                    <td colspan="1">Valuta</td>
                    <td colspan="2"></td>
                    <td colspan="4">Dokumentavgifts&#229;rsak</td>
                </tr>
            </xsl:otherwise>
        </xsl:choose>
        <tr class="dokumentavgiftsgrunnlag">
            <td colspan="1" class="beloepsverdi">
                <xsl:call-template name="formaterBeloepsverdi">
                    <xsl:with-param name="beloepsverdi" select="inn:dokumentavgiftsgrunnlag/inn:beloepsverdi"/>
                </xsl:call-template>
            </td>
            <td colspan="1" class="valutakode">
                <xsl:value-of select="inn:dokumentavgiftsgrunnlag/inn:valutakode/inn:kodeverdi"/>
            </td>
            <td colspan="2" class="beloepstekst">
                <xsl:value-of select="inn:dokumentavgiftsgrunnlag/inn:beloepstekst"/>
            </td>
            <td colspan="4" class="dokumentavgiftsaarsak">
                <xsl:value-of select="inn:dokumentavgiftsaarsak/inn:navn"/>
            </td>
        </tr>
    </xsl:template>

    <xsl:template match="inn:beloep">
        <xsl:call-template name="beloepITabell"/>
    </xsl:template>

    <xsl:template match="inn:beloepNedkvittertTil">
        <xsl:call-template name="beloepITabell"/>
    </xsl:template>

    <xsl:template match="inn:pantsettere">
        <tr class="table-header">
            <td colspan="8">Pantsetter</td>
        </tr>
        <xsl:call-template name="personerITabell">
            <xsl:with-param name="class">pantsettere</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="inn:rettighetshavere">
        <xsl:call-template name="personerITabell">
            <xsl:with-param name="class">rettighetshavere</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="inn:realkobletTil">
        <xsl:call-template name="registerenhetsretterITabell">
            <xsl:with-param name="class">realkobletTil</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template match="inn:omsatteRegisterenhetsretter">
        <xsl:for-each select="inn:omsattRegisterenhetsrett">
            <tr class="table-subheader">
                <td colspan="4">Registerenhet</td>
                <td colspan="2">Type rettighet</td>
                <td colspan="1">Brukstype</td>
                <td colspan="1">Boligtype</td>
            </tr>

            <tr>
                <td colspan="4" class="registerenhet">
                    <xsl:call-template name="formaterRegisterenhet">
                        <xsl:with-param name="registerenhet" select="inn:registerenhetsrett/inn:registerenhet"/>
                    </xsl:call-template>
                </td>
                <td colspan="2" class="registerenhetsrettstype">
                    <xsl:value-of select="inn:registerenhetsrett/inn:registerenhetsrettstype/inn:navn"/>
                </td>
                <td colspan="1" class="brukstype">
                    <xsl:value-of select="inn:brukstype/inn:navn"/>
                </td>
                <td colspan="1" class="boligtype">
                    <xsl:value-of select="inn:boligtype/inn:navn"/>
                </td>
            </tr>

            <xsl:if test="inn:omsatteRegisterenhetsrettsandeler/inn:utstedte/inn:utstederandel/*">
                <tr class="table-subheader">
                    <td colspan="1" bgcolor="white"/>
                    <td colspan="3">Utsteder<xsl:call-template name="dynamiskFotnoteNummer">
                            <xsl:with-param name="rettstiftelse" select="//inn:dokument/inn:rettsstiftelser/*"/>
                            <xsl:with-param name="inn" select="'utstedte'"/>
                        </xsl:call-template>
                    </td>
                    <td colspan="2">F.nr./org.nr.</td>
                    <td colspan="2">Ideell andel</td>
                </tr>
                <xsl:for-each select="inn:omsatteRegisterenhetsrettsandeler/inn:utstedte/inn:utstederandel">
                    <tr class="rettighetshaver">
                        <td colspan="1"/>
                        <td colspan="3" class="navn">
                            <xsl:value-of select="inn:utsteder/inn:navn"/>
                        </td>
                        <td colspan="2" class="identifikasjonsnummer">
                            <xsl:call-template name="formaterIdentifikasjonsnummer">
                                <xsl:with-param name="idnr" select="inn:utsteder/inn:identifikasjonsnummer"/>
                            </xsl:call-template>
                        </td>
                        <td colspan="2" class="broek">
                            <xsl:value-of select="concat(inn:teller, '/', inn:nevner)"/>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>


            <tr class="table-subheader">
                <td colspan="1" bgcolor="white"/>
                <td colspan="3">Fra</td>
                <td colspan="2">F.nr./org.nr.</td>
                <td colspan="2">Ideell andel</td>
            </tr>
            <xsl:for-each select="inn:omsatteRegisterenhetsrettsandeler/inn:solgte/inn:registerenhetsrettsandel">
                <tr class="rettighetshaver">
                    <td colspan="1"/>
                    <td colspan="3" class="navn">
                        <xsl:value-of select="inn:rettighetshaver/inn:navn"/>
                    </td>
                    <td colspan="2" class="identifikasjonsnummer">
                        <xsl:call-template name="formaterIdentifikasjonsnummer">
                            <xsl:with-param name="idnr" select="inn:rettighetshaver/inn:identifikasjonsnummer"/>
                        </xsl:call-template>
                    </td>
                    <td colspan="2" class="broek">
                        <xsl:value-of select="concat(inn:teller, '/', inn:nevner)"/>
                    </td>
                </tr>
            </xsl:for-each>

            <tr class="table-subheader">
                <td colspan="1" bgcolor="white"/>
                <td colspan="3">Til<xsl:call-template name="dynamiskFotnoteNummer">
                        <xsl:with-param name="rettstiftelse" select="//inn:dokument/inn:rettsstiftelser/*"/>
                        <xsl:with-param name="inn" select="'kjoeper'"/>
                    </xsl:call-template>
                </td>
                <td colspan="2">F.nr./org.nr.</td>
                <td colspan="2">Ideell andel</td>
            </tr>
            <xsl:for-each select="inn:omsatteRegisterenhetsrettsandeler/inn:kjoepte/inn:registerenhetsrettsandel">
                <tr class="rettighetshaver">
                    <td colspan="1"/>
                    <td colspan="3" class="navn">
                        <xsl:value-of select="inn:rettighetshaver/inn:navn"/>
                    </td>
                    <td colspan="2" class="identifikasjonsnummer">
                        <xsl:call-template name="formaterIdentifikasjonsnummer">
                            <xsl:with-param name="idnr" select="inn:rettighetshaver/inn:identifikasjonsnummer"/>
                        </xsl:call-template>
                    </td>
                    <td colspan="2" class="broek">
                        <xsl:value-of select="concat(inn:teller, '/', inn:nevner)"/>
                    </td>
                </tr>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:hefterI">
        <xsl:call-template name="delAvRegisterenhetsrett"/>
    </xsl:template>

    <xsl:template match="inn:gjelder">
        <xsl:call-template name="delAvRegisterenhetsrett"/>
    </xsl:template>

    <xsl:template name="delAvRegisterenhetsrett">
        <xsl:for-each select="inn:delAvRegisterenhetsrett/inn:registerenhetsrett/inn:registerenhet">
            <tr class="table-subheader">
                <td colspan="5">Registerenhet</td>
                <td colspan="3">Type rettighet</td>
            </tr>
            <tr class="registerenhetsrett">
                <td colspan="5" class="registerenhet">
                    <xsl:call-template name="formaterRegisterenhet">
                        <xsl:with-param name="registerenhet" select="."/>
                    </xsl:call-template>
                </td>
                <td colspan="3" class="registerenhetsrettstype">
                    <xsl:value-of select="../inn:registerenhetsrettstype/inn:navn"/>
                </td>
            </tr>
            <xsl:if test="../../inn:begrensetTil/*">
                <tr class="table-subheader">
                    <td colspan="1" bgcolor="white"/>
                    <td colspan="2">Ideell andel</td>
                    <td colspan="3">Tilh&#248;rende</td>
                    <td colspan="2">F.nr./org.nr.</td>
                </tr>
                <xsl:for-each select="../../inn:begrensetTil/inn:registerenhetsrettsandel">
                    <tr class="begrensettil">
                        <td colspan="1"/>
                        <td colspan="2" class="broek">
                            <xsl:value-of select="concat(inn:teller, '/', inn:nevner)"/>
                        </td>
                        <td colspan="3" class="navn">
                            <xsl:value-of select="inn:rettighetshaver/inn:navn"/>
                        </td>
                        <td colspan="2" class="identifikasjonsnummer">
                            <xsl:call-template name="formaterIdentifikasjonsnummer">
                                <xsl:with-param name="idnr" select="inn:rettighetshaver/inn:identifikasjonsnummer"/>
                            </xsl:call-template>
                        </td>
                    </tr>
                </xsl:for-each>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:endrer">

        <xsl:for-each select="inn:delAvRett/inn:rettsstiftelse">
            <tr class="rettsstiftelse">
                <xsl:if test="inn:pant | inn:annenHeftelse | inn:tvangsforretning">
                    <td colspan="8">
                        <xsl:apply-templates select="inn:pant | inn:annenHeftelse | inn:tvangsforretning"/>
                    </td>
                </xsl:if>
                <xsl:if test="inn:rettsstiftelseReferanse">
                    <xsl:apply-templates select="inn:rettsstiftelseReferanse"/>
                </xsl:if>
            </tr>
        </xsl:for-each>
        <xsl:for-each select="inn:delAvRett/inn:begrensetTil">
            <tr class="table-header">
                <td colspan="8">Begrenset til registerenhet</td>
            </tr>
            <tr class="begrensetTil">
                <xsl:call-template name="delAvRegisterenhetsrett"/>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:rettsstiftelseReferanse">
        <td class="dokumentaar">
            <xsl:value-of select="inn:dokumentaar"/>
        </td>
        <td class="dokumentnummer">
            <xsl:value-of select="inn:dokumentnummer"/>
        </td>
        <td class="rettsstiftelsesnummer">
            <xsl:value-of select="inn:rettsstiftelsesnummer"/>
        </td>
        <td class="embetenummer">
            <xsl:value-of select="inn:embetenummer"/>
        </td>
        <td colspan="4" class="rettsstiftelsestype">
            <xsl:value-of select="inn:rettsstiftelsestype/inn:navn"/>
        </td>
    </xsl:template>

    <xsl:template match="inn:veketFor">
        <tr class="table-header">
            <td colspan="2">Vikelseskode</td>
        </tr>
        <tr>
            <td colspan="2">Viker for</td>
        </tr>

        <tr class="table-header">
            <td colspan="8">Rettsstiftelse(r) det vikes prioritet for</td>
        </tr>

        <xsl:for-each select="inn:rettsstiftelseHenvisning">
            <xsl:choose>
                <xsl:when test="inn:rettsstiftelseReferanse">
                    <tr class="table-subheader">
                        <td>Dokument&#229;r</td>
                        <td>Dokumentnr.</td>
                        <td>Rettsst.nr.</td>
                        <td>Embetenr.</td>
                        <td colspan="4">Rettsstiftelsestype</td>
                    </tr>
                    <tr class="veketFor">
                        <xsl:apply-templates select="inn:rettsstiftelseReferanse"/>
                    </tr>

                </xsl:when>
                <xsl:otherwise>
                    <tr class="veketFor">
                        <td colspan="8">
                            <xsl:apply-templates
                                    select="inn:annenHeftelse | inn:tvangsforretning | inn:pant"/>
                        </td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:sidestiltMed">
        <tr class="table-header">
            <td colspan="2">Vikelseskode</td>
        </tr>
        <tr>
            <td colspan="2">Sidestilt med</td>
        </tr>


        <tr class="table-header">
            <td colspan="8">Rettsstiftelse(r) det sidestilles prioritet med</td>
        </tr>
        <xsl:for-each select="inn:rettsstiftelseHenvisning">
            <xsl:choose>
                <xsl:when test="inn:rettsstiftelseReferanse">
                    <tr class="table-subheader">
                        <td>Dokument&#229;r</td>
                        <td>Dokumentnr.</td>
                        <td>Rettsst.nr.</td>
                        <td>Embetenr.</td>
                        <td colspan="4">Rettsstiftelsestype</td>
                    </tr>
                    <tr class="sidestiltMed">
                        <xsl:apply-templates select="inn:rettsstiftelseReferanse"/>
                    </tr>

                </xsl:when>
                <xsl:otherwise>
                    <tr class="sidestiltMed">
                        <td colspan="8">
                            <xsl:apply-templates
                                    select="inn:annenHeftelse | inn:tvangsforretning | inn:pant"/>
                        </td>
                    </tr>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
    </xsl:template>


    <xsl:template match="inn:tekster">
        <tr class="table-subheader">
            <td colspan="8">Teksttype</td>
        </tr>
        <xsl:for-each select="inn:tekst">
            <tr class="tekst">
                <td colspan="8" class="teksttype">
                    <xsl:value-of select="inn:teksttype/inn:navn"/>
                </td>
            </tr>
            <xsl:if test="inn:fritekst">
                <tr>
                    <td colspan="1"></td>
                    <td colspan="7" class="table-subheader">Fritekst</td>
                </tr>
                <tr class="tekst">
                    <td colspan="1"></td>
                    <td colspan="7" class="fritekst">
                        <xsl:value-of select="inn:fritekst"/>
                    </td>
                </tr>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:erklaeringerOmSivilstand">
        <tr class="table-header">
            <td colspan="8">Erkl&#230;ring om sivilstand</td>
        </tr>
        <tr class="table-subheader">
            <td colspan="2">Erkl&#230;ring for</td>
            <td colspan="2">F.nr.</td>
            <td colspan="1">Krever samtykke<xsl:call-template name="dynamiskFotnoteNummer">
                                               <xsl:with-param name="rettstiftelse" select="//inn:dokument/inn:rettsstiftelser/*"/>
                                               <xsl:with-param name="inn" select="'samtykke'"/>
                                           </xsl:call-template>
            </td>
            <td colspan="2">Ektefelle/ registrert partner</td>
            <td colspan="1">F.nr.</td>
        </tr>
        <xsl:for-each select="inn:erklaeringOmSivilstand">
            <tr class="erklaeringomsivilstand">
                <td colspan="2" class="erklaeringfor">
                    <xsl:value-of select="inn:erklaeringFor/inn:navn"/>
                </td>
                <td colspan="2" class="erklaeringforidentifikasjonsnummer">
                    <xsl:call-template name="formaterIdentifikasjonsnummer">
                        <xsl:with-param name="idnr" select="inn:erklaeringFor/inn:identifikasjonsnummer"/>
                    </xsl:call-template>
                </td>
                <td colspan="1" class="kreversamtykke">
                    <xsl:choose>
                        <xsl:when test="string(inn:kreverSamtykke) = 'false'">Nei</xsl:when>
                        <xsl:otherwise>Ja</xsl:otherwise>
                    </xsl:choose>
                </td>
                <td colspan="2" class="ektefellepartner">
                    <xsl:value-of select="inn:ektefellePartner/inn:navn"/>
                </td>
                <td colspan="1" class="ektefellepartneridentifikasjonsnummer">
                    <xsl:call-template name="formaterIdentifikasjonsnummer">
                        <xsl:with-param name="idnr" select="inn:ektefellePartner/inn:identifikasjonsnummer"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template match="inn:omfang">
        <xsl:if test="inn:vilkaarGjelder = 'true'">
            <tr>
                <td colspan="8" id="omfang">Pantedokumentet tjener som sikkerhet for partenes rettigheter og
                    forpliktelser etter inng&#229;tt avtale, samt som sikkerhet for eiendomsmeglerens vederlag og utlegg
                    iht. oppdragsavtalen. Pantsettelsen omfatter all n&#229;v&#230;rende og fremtidig bebyggelse med
                    tilbeh&#248;r og rettigheter, jf. panteloven &#167; 2-2, 2-3 og 2-4.
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

    <xsl:template match="inn:forsikring">
        <xsl:if test="inn:vilkaarGjelder = 'true'">
            <tr>
                <td colspan="8" id="forsikring">Pantsetter plikter &#229; holde pantet tilstrekkelig forsikret jf.
                    panteloven &#167; 1-7 (4). Ubetalt forsikringspremie kan panthaver dekke for pantsetters regning.
                    Erstatning som f&#248;lge av hel/delvis skade p&#229; eiendommen, kan panthaver, med de begrensinger
                    som f&#248;lger av <div>lov/avtale, kreve at i sin helhet benyttes til innfrielse av gjelden.</div>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

    <xsl:template match="inn:forfall">
        <xsl:if test="inn:vilkaarGjelder = 'true'">
            <tr>
                <td colspan="8" id="forfall">Panthaver kan kreve innfrielse straks det inntrer forhold som nevnt i
                    panteloven &#167; 1-9. Dersom gjelden ikke betales ved forfall kan panthaver kreve hel/delvis
                    dekning eller innfrielse uten s&#248;ksm&#229;l, jf. tvangsfullbyrdelsesloven &#167; 7-2 (a).
                </td>
            </tr>
        </xsl:if>
    </xsl:template>

    <xsl:template name="beloepITabell">
        <tr class="table-subheader">
            <td colspan="1">Bel&#248;p</td>
            <td colspan="1">Valuta</td>
            <td colspan="6">Tilleggsansvar</td>
        </tr>
        <xsl:for-each select="inn:beloep">
            <tr class="beloep">
                <td colspan="1" class="beloepsverdi">
                    <xsl:call-template name="formaterBeloepsverdi">
                        <xsl:with-param name="beloepsverdi" select="inn:beloepsverdi"/>
                    </xsl:call-template>
                </td>
                <td colspan="1" class="valutakode">
                    <xsl:value-of select="inn:valutakode/inn:kodeverdi"/>
                </td>
                <td colspan="6" class="beloepstekst">
                    <xsl:value-of select="inn:beloepstekst"/>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="personerITabell">
        <xsl:param name="class"/>
        <tr class="table-subheader">
            <td colspan="5">Navn</td>
            <td colspan="3">F.nr./org.nr.</td>
        </tr>
        <xsl:for-each select="inn:person">
            <tr class="{$class}">
                <td colspan="5" class="navn">
                    <xsl:value-of select="inn:navn"/>
                </td>
                <td colspan="3" class="identifikasjonsnummer">
                    <xsl:call-template name="formaterIdentifikasjonsnummer">
                        <xsl:with-param name="idnr" select="inn:identifikasjonsnummer"/>
                    </xsl:call-template>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="realkobletTilITabell">
        <xsl:param name="class"/>
        <tr class="table-subheader">
            <td colspan="5">Registerenhet</td>
            <td colspan="3">Type rettighet</td>
        </tr>
        <xsl:for-each select="inn:registerenhetsrett">
            <tr class="{$class}">
                <td colspan="5" class="registerenhet">
                    <xsl:call-template name="formaterRegisterenhet">
                        <xsl:with-param name="registerenhet" select="inn:registerenhet"/>
                    </xsl:call-template>
                </td>
                <td colspan="3" class="registerenhetsrettstype">
                    <xsl:value-of select="inn:registerenhetsrettstype/inn:navn"/>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="registerenhetsretterITabell">
        <xsl:param name="class"/>
        <xsl:for-each select="inn:registerenhetsrett">
            <tr class="table-subheader">
                <td colspan="5">Registerenhet</td>
                <td colspan="3">Type rettighet</td>
            </tr>
            <tr class="{$class}">
                <td colspan="5" class="registerenhet">
                    <xsl:call-template name="formaterRegisterenhet">
                        <xsl:with-param name="registerenhet" select="inn:registerenhet"/>
                    </xsl:call-template>
                </td>
                <td colspan="3" class="registerenhetsrettstype">
                    <xsl:value-of select="inn:registerenhetsrettstype/inn:navn"/>
                </td>
            </tr>
        </xsl:for-each>
    </xsl:template>

    <xsl:template name="formaterRegisterenhet">
        <xsl:param name="registerenhet"/>
        <xsl:if test="$registerenhet/inn:matrikkelenhet">
            <xsl:call-template name="formaterMatrikkelenhet">
                <xsl:with-param name="matrikkelenhet" select="$registerenhet/inn:matrikkelenhet"/>
            </xsl:call-template>
        </xsl:if>
        <xsl:if test="$registerenhet/inn:borettslagsandel">
            <xsl:call-template name="formaterBorettslagsandel">
                <xsl:with-param name="borettslagsandel" select="$registerenhet/inn:borettslagsandel"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>

    <xsl:template name="formaterMatrikkelenhet">
        <xsl:param name="matrikkelenhet"/>
        <xsl:variable name="tekststart" select="concat($matrikkelenhet/inn:kommunenavn, ' kommune, knr. ', $matrikkelenhet/inn:kommunenummer,
        ' gnr. ', $matrikkelenhet/inn:gaardsnummer, ' bnr. ', $matrikkelenhet/inn:bruksnummer) "/>
        <xsl:choose>
            <xsl:when
                    test="((number($matrikkelenhet/inn:festenummer) &gt; 0) and (number($matrikkelenhet/inn:festenummer) &gt; 0))">
                <xsl:value-of
                        select="concat($tekststart, ' fnr. ', $matrikkelenhet/inn:festenummer, ' snr. ', $matrikkelenhet/inn:seksjonsnummer)"/>
            </xsl:when>
            <xsl:when test="(number($matrikkelenhet/inn:festenummer) &gt; 0)">
                <xsl:value-of select="concat($tekststart, ' fnr. ', $matrikkelenhet/inn:festenummer)"/>
            </xsl:when>
            <xsl:when test="(number($matrikkelenhet/inn:seksjonsnummer) &gt; 0)">
                <xsl:value-of select="concat($tekststart, ' snr. ', $matrikkelenhet/inn:seksjonsnummer)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$tekststart"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="formaterBorettslagsandel">
        <xsl:param name="borettslagsandel"/>
        <xsl:variable name="brlnr">
            <xsl:call-template name="formaterIdentifikasjonsnummer">
                <xsl:with-param name="idnr" select="$borettslagsandel/inn:borettslagnummer"/>
            </xsl:call-template>
        </xsl:variable>

        <xsl:value-of
                select="concat($borettslagsandel/inn:borettslagnavn, ', org.nr. ', $brlnr, ' andelsnr. ', $borettslagsandel/inn:andelsnummer) "/>
    </xsl:template>

    <xsl:template name="formaterIdentifikasjonsnummer">
        <xsl:param name="idnr"/>
        <xsl:variable name="len" select="string-length($idnr)"/>
        <xsl:choose>
            <xsl:when test="$len = 11">
                <xsl:value-of select="concat(substring($idnr, 1, 6), ' ', substring($idnr, 7))"/>
            </xsl:when>
            <xsl:when test="$len = 9">
                <xsl:value-of
                        select="concat(substring($idnr, 1, 3), ' ', substring($idnr, 4, 3), ' ', substring($idnr, 7, 3))"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$idnr"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:decimal-format name="beloepsverdiFormat" grouping-separator=" " decimal-separator=","/>

    <xsl:template name="formaterBeloepsverdi">
        <xsl:param name="beloepsverdi"/>
        <xsl:value-of select="format-number($beloepsverdi, '### ###,##', 'beloepsverdiFormat')"/>
    </xsl:template>

    <xsl:template name="rettsstiftelseNavnOgNummer">
        <xsl:param name="rettsstiftelseNavn"/>
        <xsl:param name="index"/>

        <tr>
            <td colspan="6" class="table-header">
                <xsl:value-of select="$rettsstiftelseNavn"/>
            </td>
            <td colspan="2" class="align-right">
                <span>
                    <xsl:attribute name="id">
                        <xsl:value-of select="concat('rettsstiftelse',$index)"/>
                    </xsl:attribute>
                </span>
            </td>
        </tr>

    </xsl:template>

    <xsl:template name="jaNei">
        <xsl:param name="booleanValue"/>
        <xsl:choose>
            <xsl:when test="$booleanValue= 'true'">
                <xsl:value-of select="'Ja'"/>
            </xsl:when>
            <xsl:when test="$booleanValue= 'false'">
                <xsl:value-of select="'Nei'"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>Ukjent</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="rettstiftelseStandardTekst">
        <xsl:param name="rettstiftelseTypeKode"/>
        <xsl:choose>
            <xsl:when test="$rettstiftelseTypeKode= 'AH_URK'">
                <tr>
                    <td class="rettstiftelseStandardTekst" colspan="8">Erkl&#230;ring om at eiendommen ikke kan overskj&#248;tes,
                        utleies, beheftes eller p&#229; noen annen m&#229;te rettslig disponeres over uten etter
                        skriftlig samtykke fra rettighetshaveren.
                    </td>
                </tr>
            </xsl:when>
            <xsl:when test="$rettstiftelseTypeKode= 'OB_PDB'">
                <tr>
                    <td class="rettstiftelseStandardTekst" colspan="8">Pantsettelsen gjelder refinansiering av l&#229;n,
                        jf. forskrift om gebyr for tinglysing mv. &#167; 1 andre ledd.
                    </td>
                </tr>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="dynamiskFotnoteNummer">
        <xsl:param name="rettstiftelse"/>
        <xsl:param name="inn"/>
        <xsl:variable name="harUtstedte"
                      select="count($rettstiftelse/inn:omsetning/inn:omsatteRegisterenhetsretter/inn:omsattRegisterenhetsrett/inn:omsatteRegisterenhetsrettsandeler/inn:utstedte) &gt; 0"/>
        <xsl:variable name="erklaeringOmSivilstand"
                      select="$rettstiftelse/inn:erklaeringerOmSivilstand/inn:erklaeringOmSivilstand"/>
        <xsl:variable name="seksjonsnummer"
                      select="$rettstiftelse/inn:omsetning/inn:omsatteRegisterenhetsretter/inn:omsattRegisterenhetsrett/inn:registerenhetsrett/inn:registerenhet/inn:matrikkelenhet/inn:seksjonsnummer"/>

        <xsl:choose>
            <xsl:when test="$harUtstedte and $inn='utstedte'">
                <sup>1</sup>
            </xsl:when>
            <xsl:when test="count($erklaeringOmSivilstand) &gt; 0 and (local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0">
                <xsl:choose>
                    <xsl:when test="$harUtstedte">
                        <xsl:choose>
                            <xsl:when test="$inn='kjoeper'">
                                <sup>2</sup>
                            </xsl:when>
                            <xsl:when test="$inn='samtykke'">
                                <sup>3</sup>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:choose>
                            <xsl:when test="$inn='kjoeper'">
                                <sup>1</sup>
                            </xsl:when>
                            <xsl:when test="$inn='samtykke'">
                                <sup>2</sup>
                            </xsl:when>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="count($erklaeringOmSivilstand) &gt; 0 and $inn='samtykke'">
                <xsl:choose>
                    <xsl:when test="$harUtstedte">
                        <sup>2</sup>
                    </xsl:when>
                    <xsl:otherwise>
                        <sup>1</sup>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:when test="(local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0 and $inn='kjoeper'">
                <xsl:choose>
                    <xsl:when test="$harUtstedte">
                        <sup>2</sup>
                    </xsl:when>
                    <xsl:otherwise>
                        <sup>1</sup>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>

    </xsl:template>

    <xsl:template name="fotnote">
        <xsl:param name="rettstiftelse"/>
        <xsl:variable name="utstedte"
                      select="$rettstiftelse/inn:omsetning/inn:omsatteRegisterenhetsretter/inn:omsattRegisterenhetsrett/inn:omsatteRegisterenhetsrettsandeler/inn:utstedte"/>
        <xsl:variable name="erklaeringOmSivilstand"
                      select="$rettstiftelse/inn:erklaeringerOmSivilstand/inn:erklaeringOmSivilstand"/>
        <xsl:variable name="seksjonsnummer"
                      select="$rettstiftelse/inn:omsetning/inn:omsatteRegisterenhetsretter/inn:omsattRegisterenhetsrett/inn:registerenhetsrett/inn:registerenhet/inn:matrikkelenhet/inn:seksjonsnummer"/>

        <xsl:choose>
            <xsl:when test="count($utstedte) &gt; 0">
                <xsl:call-template name="utstedteFotnote">
                    <xsl:with-param name="nummer" select="1"/>
                </xsl:call-template>
                <xsl:choose>
                    <xsl:when
                            test="count($erklaeringOmSivilstand) &gt; 0 and (local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0">
                        <xsl:call-template name="signaturFotnote">
                            <xsl:with-param name="nummer" select="2"/>
                        </xsl:call-template>
                        <xsl:call-template name="samtykkeFotnote">
                            <xsl:with-param name="nummer" select="3"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="count($erklaeringOmSivilstand) &gt; 0">
                        <xsl:call-template name="samtykkeFotnote">
                            <xsl:with-param name="nummer" select="2"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when
                            test="(local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0">
                        <xsl:call-template name="signaturFotnote">
                            <xsl:with-param name="nummer" select="2"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                    <xsl:when
                            test="count($erklaeringOmSivilstand) &gt; 0 and (local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0">
                        <xsl:call-template name="signaturFotnote">
                            <xsl:with-param name="nummer" select="1"/>
                        </xsl:call-template>
                        <xsl:call-template name="samtykkeFotnote">
                            <xsl:with-param name="nummer" select="2"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when test="count($erklaeringOmSivilstand) &gt; 0">
                        <xsl:call-template name="samtykkeFotnote">
                            <xsl:with-param name="nummer" select="1"/>
                        </xsl:call-template>
                    </xsl:when>
                    <xsl:when
                            test="(local-name($rettstiftelse)='eierskifteMatrikkelenhet' or local-name($rettstiftelse)='overdragelseAvFesterett') and $seksjonsnummer &gt; 0">
                        <xsl:call-template name="signaturFotnote">
                            <xsl:with-param name="nummer" select="1"/>
                        </xsl:call-template>
                    </xsl:when>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>

    <xsl:template name="utstedteFotnote">
        <xsl:param name="nummer"/>
        <p>
            <sup><xsl:value-of select="$nummer"/></sup> Utsteder er den som selger registerenheten. Dette kan v&#230;re en annen enn den som er registrert som eier/fester i grunnboken.
        </p>
    </xsl:template>

    <xsl:template name="samtykkeFotnote">
        <xsl:param name="nummer"/>
        <p>
            <sup><xsl:value-of select="$nummer"/></sup> Krever samtykke etter tinglysingsloven &#167; 13 femte ledd, jf. ekteskapsloven &#167; 32.
        </p>
    </xsl:template>

    <xsl:template name="signaturFotnote">
        <xsl:param name="nummer"/>
        <p>
            <sup><xsl:value-of select="$nummer"/></sup> Ved overdragelse av en boligseksjon, m&#229; mottaker/kj&#248;per erkl&#230;re at ervervet ikke er i strid med eierseksjonsloven &#167; 23.
        </p>
    </xsl:template>

</xsl:stylesheet>
